IF EXISTS (SELECT
						 *
					 FROM
						 sys.views
					 WHERE
						object_id = OBJECT_ID(N'[dbo].[V_RC_CLI_CONVENIADO_RELACAO]'))
	DROP VIEW [dbo].[V_RC_CLI_CONVENIADO_RELACAO]

GO
--SELECT * FROM V_RC_CLI_CONVENIADO_RELACAO
CREATE VIEW V_RC_CLI_CONVENIADO_RELACAO 
WITH ENCRYPTION
AS
SELECT 
	RC_CLI_CONV.CD_EMP,
	RC_CLI_CONV.CD_CONV,
	RC_CLI_CONV.DS_CONV,
	RC_CLI.CD_CLI, 
	RC_CLI.RZ_CLI, 	
	RC_CLI.CGC_CPF, 
	RC_CLI_CONV_RC_CLI.MATRICULA, 
	RC_CLI_CONV_RC_CLI.VLR_CRED, 
	RC_CLI_CONV_RC_CLI.VLR_DEB, 
	ISNULL(RC_CLI_FIDELI_CARTAO.NR_CARTAO,'') AS NR_CARTAO,  
	CASE WHEN ISNULL(RC_CLI_CONV_RC_CLI.STS_CRED,0)=0 THEN
		'ATIVO'
	ELSE
		'INATIVO'
	END AS STS_CRED, 
	CASE WHEN ISNULL(RC_CLI_CONV_RC_CLI.STS_ATIVO,0)= 0 THEN     
		'ATIVO' 
	ELSE     
		'INATIVO' 
	END AS STS_ATIVO, 
	CASE WHEN ISNULL(RC_CLI.FLAG_CONVENIADO_DEMISSAO,0)=0 THEN
		'NAO'
	ELSE
		'SIM'
	END AS  DEMITIDO, 
	CASE WHEN ISNULL(DEP.CD_CLI_TITULAR,0) = 0 THEN 
		'NAO' 
	ELSE 
		'SIM' 
	END AS DEPENDENTE 
FROM 
	RC_CLI INNER JOIN RC_CLI_CONV_RC_CLI ON  
	RC_CLI_CONV_RC_CLI.CD_EMP = RC_CLI.CD_EMP AND 
	RC_CLI_CONV_RC_CLI.CD_CLI = RC_CLI.CD_CLI 
	LEFT OUTER JOIN RC_CLI_FIDELI_CARTAO ON 
	RC_CLI_FIDELI_CARTAO.CD_EMP = RC_CLI.CD_EMP AND 
	RC_CLI_FIDELI_CARTAO.CD_CLI = RC_CLI.CD_CLI 
	LEFT JOIN RC_CLI_CONV_DEPENDENTE DEP ON  
	RC_CLI.CD_CLI = DEP.CD_CLI_DEPEND   
	INNER JOIN RC_CLI_CONV ON
	RC_CLI_CONV_RC_CLI.CD_EMP=RC_CLI_CONV.CD_EMP AND
	RC_CLI_CONV_RC_CLI.CD_CONV = RC_CLI_CONV.CD_CONV
